/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.preferences.SettingsTransfer;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerConnectionTestJob;

public class ServerLocationWizardPage
extends WizardPage {
    private final IServer server;
    private Text serverIdText;
    private Text serverNameText;
    private Text serverUrlText;
    private Text serverUsernameText;
    private Text serverPasswordText;
    private IStatus status;
    private final boolean edit;
    private boolean serverIdManuallyChanged;
    private ModifyListener idModifyListener;
    private final String defaultServerId;

    public ServerLocationWizardPage() {
        this((IServer)null);
    }

    public ServerLocationWizardPage(String defaultServerId) {
        this(null, defaultServerId);
    }

    public ServerLocationWizardPage(IServer sonarServer) {
        this(sonarServer, null);
    }

    public ServerLocationWizardPage(IServer sonarServer, String defaultServerId) {
        super("server_location_page", "SonarQube Server Configuration", SonarLintImages.IMG_WIZBAN_NEW_SERVER);
        this.edit = sonarServer != null;
        this.server = sonarServer;
        this.defaultServerId = defaultServerId;
    }

    public void createControl(Composite parent) {
        final FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        ScrolledForm form = toolkit.createScrolledForm(parent);
        form.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        form.getBody().setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, true);
        form.setLayoutData((Object)layoutData);
        Label labelUrl = new Label(form.getBody(), 0);
        labelUrl.setText(Messages.ServerLocationWizardPage_label_host);
        this.serverUrlText = new Text(form.getBody(), 2052);
        GridData gd = new GridData(768);
        this.serverUrlText.setLayoutData((Object)gd);
        if (this.edit) {
            this.serverUrlText.setText(StringUtils.defaultString((String)this.server.getHost()));
        } else {
            this.serverUrlText.setText("https://");
        }
        this.serverUrlText.setFocus();
        this.serverUrlText.setSelection(this.serverUrlText.getText().length());
        this.serverUrlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ServerLocationWizardPage.this.edit && !ServerLocationWizardPage.this.serverIdManuallyChanged) {
                    try {
                        URL url = new URL(ServerLocationWizardPage.this.serverUrlText.getText());
                        ServerLocationWizardPage.this.serverIdText.removeModifyListener(ServerLocationWizardPage.this.idModifyListener);
                        ServerLocationWizardPage.this.serverIdText.setText(StringUtils.substringBefore((String)url.getHost(), (String)"."));
                        ServerLocationWizardPage.this.serverIdText.addModifyListener(ServerLocationWizardPage.this.idModifyListener);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                ServerLocationWizardPage.this.dialogChanged();
            }
        });
        Label labelName = new Label(form.getBody(), 0);
        labelName.setText(Messages.ServerLocationWizardPage_label_name);
        this.serverNameText = new Text(form.getBody(), 2052);
        this.serverNameText.setLayoutData((Object)new GridData(768));
        if (this.edit) {
            this.serverNameText.setText(StringUtils.defaultString((String)this.server.getName()));
        }
        Label labelUsername = new Label(form.getBody(), 0);
        labelUsername.setText(Messages.ServerLocationWizardPage_label_username);
        this.serverUsernameText = new Text(form.getBody(), 2052);
        this.serverUsernameText.setLayoutData((Object)new GridData(768));
        if (this.edit) {
            this.serverUsernameText.setText(StringUtils.defaultString((String)ServersManager.getUsername((IServer)this.server)));
        }
        Label labelPassword = new Label(form.getBody(), 0);
        labelPassword.setText(Messages.ServerLocationWizardPage_label_password);
        this.serverPasswordText = new Text(form.getBody(), 0x400804);
        this.serverPasswordText.setLayoutData((Object)new GridData(768));
        if (this.edit) {
            this.serverPasswordText.setText(StringUtils.defaultString((String)ServersManager.getPassword((IServer)this.server)));
        }
        this.createTestConnectionButton(form.getBody());
        this.createServerIdField(form);
        if (this.edit) {
            this.dialogChanged();
        }
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)form.getBody());
    }

    private void createServerIdField(final ScrolledForm form) {
        ExpandableComposite excomposite = new ExpandableComposite(form.getBody(), 0, 18);
        excomposite.setText("Advanced");
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){
            boolean notExpanded = true;

            public void expansionStateChanged(ExpansionEvent e) {
                super.expansionStateChanged(e);
                form.reflow(true);
                if (e.getState() && this.notExpanded) {
                    ServerLocationWizardPage.this.getShell().setRedraw(false);
                    Rectangle shellBounds = ServerLocationWizardPage.this.getShell().getBounds();
                    int entriesToShow = Math.min(4, SettingsTransfer.getSettingsTransfers().length);
                    shellBounds.height += ServerLocationWizardPage.this.convertHeightInCharsToPixels(entriesToShow) + 4;
                    ServerLocationWizardPage.this.getShell().setBounds(shellBounds);
                    ServerLocationWizardPage.this.getShell().setRedraw(true);
                    this.notExpanded = false;
                }
            }
        });
        Composite container = new Composite((Composite)excomposite, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        boolean isEditable = !this.edit;
        Label labelId = new Label(container, 0);
        labelId.setText(Messages.ServerLocationWizardPage_label_id);
        this.serverIdText = new Text(container, isEditable ? 2052 : 2056);
        GridData gdId = new GridData(768);
        this.serverIdText.setLayoutData((Object)gdId);
        this.serverIdText.setEnabled(isEditable);
        this.serverIdText.setEditable(isEditable);
        if (this.edit) {
            this.serverIdText.setText(StringUtils.defaultString((String)this.server.getId()));
        } else if (this.defaultServerId != null) {
            this.serverIdText.setText(this.defaultServerId);
            this.serverIdManuallyChanged = true;
        } else {
            this.serverIdManuallyChanged = false;
        }
        this.idModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerLocationWizardPage.this.serverIdManuallyChanged = true;
                ServerLocationWizardPage.this.dialogChanged();
            }
        };
        this.serverIdText.addModifyListener(this.idModifyListener);
        excomposite.setClient((Control)container);
    }

    private void createTestConnectionButton(Composite container) {
        Button testConnectionButton = new Button(container, 8);
        testConnectionButton.setText(Messages.ServerLocationWizardPage_action_test);
        testConnectionButton.setToolTipText(Messages.ServerLocationWizardPage_action_test_tooltip);
        testConnectionButton.setLayoutData((Object)new GridData(256));
        testConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ServerConnectionTestJob testJob = new ServerConnectionTestJob(ServerLocationWizardPage.this.transcientServer(), ServerLocationWizardPage.this.getUsername(), ServerLocationWizardPage.this.getPassword());
                    ServerLocationWizardPage.this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)testJob);
                    ServerLocationWizardPage.this.status = testJob.getStatus();
                }
                catch (OperationCanceledException operationCanceledException) {
                    ServerLocationWizardPage.this.status = Status.CANCEL_STATUS;
                }
                catch (Exception e1) {
                    ServerLocationWizardPage.this.status = (IStatus)new Status(4, "org.sonarlint.eclipse.ui", String.valueOf(Messages.ServerLocationWizardPage_msg_error) + " " + e1.getMessage(), (Throwable)e1);
                }
                ServerLocationWizardPage.this.getWizard().getContainer().updateButtons();
                String message = ServerLocationWizardPage.this.status.getMessage();
                if (ServerLocationWizardPage.this.status.getSeverity() == 0) {
                    ServerLocationWizardPage.this.setMessage(message, 1);
                } else {
                    ServerLocationWizardPage.this.setMessage(message, 3);
                }
            }
        });
    }

    private void dialogChanged() {
        this.updateStatus(ServersManager.getInstance().validate(this.getServerId(), this.getServerUrl(), this.edit));
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getServerId() {
        return this.serverIdText.getText();
    }

    public String getServerUrl() {
        return StringUtils.removeEnd((String)this.serverUrlText.getText(), (String)"/");
    }

    public String getUsername() {
        return this.serverUsernameText.getText();
    }

    public String getPassword() {
        return this.serverPasswordText.getText();
    }

    public String getServerName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.serverNameText.getText(), (CharSequence)this.getServerId());
    }

    private IServer transcientServer() {
        return ServersManager.getInstance().create(this.getServerId(), this.getServerName(), this.getServerUrl(), this.getUsername(), this.getPassword());
    }
}

